# -*- encoding: UTF-8 -*-
r"""
__numbertext__
^0 ноль
1 один
2$ два
2 две
3 три
4 четыре
5 пять
6 шесть
7 семь
8 восемь
9 девять
10 десять
11 одиннадцать
12 двенадцать
13 тринадцать
14 четырнадцать
15 пятнадцать
16 шестнадцать
17 семнадцать
18 восемнадцать
19 девятнадцать
([23])(\d) $1|дцать $2
4(\d) сорок $1
9(\d) девяносто $1
(\d)(\d) $1десят $2
1(\d\d) сто $1
2(\d\d) двести $1
([34])(\d\d) $1ста $2
(\d)(\d\d) $1сот $2
1(\d{3}) одна тысяча $1
([234]|\d?[02-9][234])(\d{3}) $1 тысячи $2
(\d{1,3})(\d{3}) $1 тысяч $2
1(\d{6}) один миллион $1
(\d{1,3})(\d{6}) $1 миллионов $2
1(\d{9}) один миллиард $1
(\d{1,3})(\d{9}) $1 миллиардов $2
1(\d{12}) один триллион $1
(\d{1,3})(\d{12}) $1 триллионов $2
1(\d{15}) один квадриллион $1
(\d{1,3})(\d{15}) $1 квадриллионов $2
1(\d{18}) один квинтиллион $1
(\d{1,3})(\d{18}) $1 квинтиллионов $2
1(\d{21}) один секстилион $1
(\d{1,3})(\d{21}) $1 секстилионов $2
1(\d{24}) один септиллион $1
(\d{1,3})(\d{24}) $1 септиллионов $2

# negative numbers

[-−]1 минус единица
[-−](\d+) минус |$1

# decimals

"1[.,]" одна целая
"([-−]?1)[.,]" $1 целая
"([-−]?\d+)[.,]" $1 целых
"([-−]?\d+[.,])(1)" $1| и одна десятая
"([-−]?0[.,])(\d)" $1| |$2 десятых
"([-−]?\d+[.,])(\d)" $1| и |$2 десятый
"([-−]?\d+[.,])([02-9]1)" $1| и $(f:|$2) сотая
"([-−]?\d+[.,])(\d\d)" $1| и |$2 сотых
"([-−]?\d+[.,])(\d[02-9]1)" $1| и $(f:|$2) тысячная
"([-−]?\d+[.,])(\d11)" $1| и $(f:|$2) тысячных
"([-−]?\d+[.,])(\d{3})" $1| и |$2 тысячный
"([-−]?\d+[.,])(\d)(\d)(\d)(\d)" $1| |$2 |$3 |$4 |$5
"([-−]?\d+[.,]\d*)(\d)" $1| |$2


# female conversion
f:(.*)один \1одна
f:(.*) \1

# currency

# unit/subunit

us:([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*) \1
up:([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*) \2
ug:([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*) \3
ss:([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*) \4
sp:([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*) \5
sg:([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*) \6

EUR:(\D+) $(\1: евро, евро, евро, цент, цента, центов)
GBP:(\D+) $(\1: фунт стерлингов, фунт стерлингов, фунт стерлингов, пенни, пенса, пенсов)
RUB:(\D+) $(\1: рубль, рубля, рублей, копейка, копейки, копеек)
UAH:(\D+) $(\1: гривна, гривны, гривен, копейка, копейки, копеек)
USD:(\D+) $(\1: доллар США, доллара США, долларов США, цент, цента, центов)


"([A-Z]{3}) ([-−]?1)([.,]00?)?" $2| $(\1:us)
"([A-Z]{3}) ([-−]?\d*[02-9]1)([.,]00?)?" $2| $(\1:us)
"([A-Z]{3}) ([-−]?[234])([.,]00?)?" $2| $(\1:up)
"([A-Z]{3}) ([-−]?\d*[02-9][234])([.,]00?)?" $2| $(\1:up)
"([A-Z]{3}) ([-−]?\d+)([.,]00?)?" $2| $(\1:ug)

"((RUB) [-−]?\d+)[.,]([02-9])1" $1 $(\30) одна $(\2:ss)
"(([A-Z]{3}) [-−]?\d+)[.,](01)" $1 |$(1) $(\2:ss)
"((EUR|GBP|USD) [-−]?\d+)[.,]([02-9]2)" $1 $3| $(\2:sp)
"(([A-Z]{3}) [-−]?\d+)[.,]([02-9][234])" $1 |$3 $(\2:sp)
"(([A-Z]{3}) [-−]?\d+)[.,](\d)" $1 |$(\30) $(\2:sg)
"(([A-Z]{3}) [-−]?\d+)[.,](\d\d)" $1 |$3 $(\2:sg)
"""
from __future__ import unicode_literals
