# -*- encoding: UTF-8 -*-
r"""
#
# Regular number to text transducer for Serbian (Cyrillic) written in Soros
# Copyright (c) Goran Rakic <grakic@devbase.net> 2009.
#
# Released under Creative Commons 3.0 Attribution - Share Alike license
# and relicensed under GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Visit http://numbertext.org for more info on Soros language and syntax
#

__numbertext__
(\d{1,3})\.([\d.,]+) $(\1\2)

^0 нула
1 један
2 два
3 три
4 четири
5 пет
6 шест
7 седам
8 осам
9 девет
10 десет

11 једанаест
14 четрнаест
16 шеснаест
1(\d) $1наест

4(\d) четрдесет $1
5(\d) педесет $1
6(\d) шездесет $1
9(\d) деведесет $1
(\d)0 $1десет
(\d)(\d) $1десет $2

1(\d\d) сто $1
2(\d\d) двеста $1
3(\d\d) триста $1
(\d)(\d\d) $1сто $2

1(\d\d\d) хиљаду $1
2(\d\d\d) две хиљаде $1
([34])(\d\d\d) $1 хиљаде $2
(\d{0,1})1(\d)(\d\d\d) $(\11\2) хиљада $3
(\d{1,2})1(\d\d\d) $(\10) једна хиљада $2
(\d{1,2})2(\d\d\d) $(\10) две хиљаде $2
(\d{1,2})([34])(\d\d\d) $(\10) $2 хиљаде $3
(\d{1,3})(\d\d\d) $1 хиљада $2

1(\d{6}) милион $1
(\d{0,4})1(\d)(\d{6}) $(\11\2) милиона $3
(\d{1,5})1(\d{6}) $(\10) један милион $2
(\d{1,3})(\d{6}) $1 милиона $2

1(\d{9}) милијарда $1
2(\d{9}) две милијарде $1
([34])(\d{9}) $1 милијарде $2
(\d{1,2})0(\d{9}) $(\10) милијарди $2
(\d{0,1})1(\d)(\d{9}) $(\11\2) милијарди $3
(\d{1,2})1(\d{9}) $(\10) једна милијарда $2
(\d{1,2})2(\d{9}) $(\10) две милијарде $2
(\d{1,2})([34])(\d{9}) $(\10) $2 милијарде $3
(\d{1,3})(\d{9}) $1 милијарде $2

1(\d{12}) билион $1
(\d{0,4})1(\d)(\d{12}) $(\11\2) билионa $3
(\d{1,5})1(\d{12}) $(\10) један билион $2
(\d{1,6})(\d{12}) $1 билиона $2

1(\d{18}) трилион $1
(\d{0,4})1(\d)(\d{18}) $(\11\2) трилиона $3
(\d{1,5})1(\d{18}) $(\10) један трилион $2
(\d{1,6})(\d{18}) $1 трилиона $2

1(\d{24}) квадрилион $1
(\d{0,4})1(\d)(\d{24}) $(\11\2) квадрилиона $3
(\d{1,5})1(\d{24}) $(\10) један квадрилион $2
(\d{1,6})(\d{24}) $1 квадрилиона $2

1(\d{30}) квинтилион $1
(\d{0,4})1(\d)(\d{30}) $(\11\2) квинтилиона $3
(\d{1,5})1(\d{30}) $(\10) један квинтилион $2
(\d{1,6})(\d{30}) $1 квинтилиона $2

1(\d{36}) секстилион $1
(\d{0,4})1(\d)(\d{36}) $(\11\2) секстилиона $3
(\d{1,5})1(\d{36}) $(\10) један секстилион $2
(\d{1,6})(\d{36}) $1 секстилиона $2

[-−](\d+) минус $1

# Decimal code by https://twitter.com/_uranium_
"([-−]?\d+)," $1| кома
"([-−]?\d+,)([^0]\d)" $1 $2
"([-−]?\d+,\d*[1-9]?)0+$" $1
"([-−]?\d+,)(\d)(\d)(\d)" $1| |$2 |$3 |$4
"([-−]?\d+,\d*)(\d)" $1 |$2

"""
from __future__ import unicode_literals
