# -*- encoding: UTF-8 -*-
r"""
__numbertext__
^0 noll
^1$ ett
^1 en
1 ett
2 två
3 tre
4 fyra
5 fem
6 sex
7 sju
8 åtta
9 nio
10 tio
11 elva
12 tolv
13 tretton
14 fjorton
15 femton
16 sexton
17 sjutton
18 arton
19 nitton
2(\d) tjugo$1
3(\d) trettio$1
4(\d) fyrtio$1
7(\d) sjuttio$1
8(\d) åttio$1
9(\d) nittio$1
(\d)(\d) $1tio$2
(\d)(\d\d) $1|hundra$2
(1|\d?[02-9]1)(\d{3}) $1|usen $2
(\d{1,3})(\d{3}) $1tusen $2
(\d{1,3})(\d{6}) |$1 miljon$(pl:\1) $2
(\d{1,3})(\d{9}) |$1 miljard$(pl:\1) $2
(\d{1,3})(\d{12}) |$1 biljon$(pl:\1) $2
(\d{1,3})(\d{15}) |$1 biljard$(pl:\1) $2
(\d{1,3})(\d{18}) |$1 triljon$(pl:\1) $2
(\d{1,3})(\d{21}) |$1 triljard$(pl:\1) $2
(\d{1,3})(\d{24}) |$1 kvadriljon$(pl:\1) $2

# plural for big numbers
pl:1
pl:.* er

# negative number

[-−](\d+) minus |$1

# decimals

"([-−]?\d+)[.,]" $1| komma
"([-−]?\d+[.,])([^0]\d)" $1| |$2
"([-−]?\d+[.,])(\d)(\d)(\d)" $1| |$2 |$3 |$4
"([-−]?\d+[.,]\d*)(\d)" $1| |$2

# currency

# unit/subunit singular/plural
"us, (.*): (.*), (.*), (.*), (.*), (.*), (.*)" $(\2 \1) \3
"up, (.*): (.*), (.*), (.*), (.*), (.*), (.*)" $(\2 \1) \4
"ss, (.*): (.*), (.*), (.*), (.*), (.*), (.*)" $(\5 \1) \6
"sp, (.*): (.*), (.*), (.*), (.*), (.*), (.*)" $(\5 \1) \7

CHF:(\D+,.*) $(\1: cardr, schweizisk franc, schweizisk franc, cardr, centime, centime)
CNY:(\D+,.*) $(\1: cardr, yuan renminbi, yuan renminbi, cardr, fen, fen)
EUR:(\D+,.*) $(\1: cardr, euro, euro, cardn, cent, cent)
GBP:(\D+,.*) $(\1: cardn, brittiskt pund, brittiskt pund, cardr, penny, pence)
JPY:(\D+,.*) $(\1: cardr, yen, yen, cardr, sen, sen)
SEK:(\D+,.*) $(\1: cardr, svensk krona, svenska kronor, cardn, öre, öre)
USD:(\D+,.*) $(\1: cardr, US-dollar, US-dollar, cardn, cent, cent)

"([A-Z]{3}) ([-−]?1)([.,]00?)?" $(\1:us, \2)
"([A-Z]{3}) ([-−]?\d+)([.,]00?)?" $(\1:up, \2)

"(CNY [-−]?\d+)[.,]10?" $1 $2 jiao
"(CNY [-−]?\d+)[.,](\d)0?" $1 $2 jiao
"(CNY [-−]?\d+[.,]\d)1" $1 $2 fen
"(CNY [-−]?\d+[.,]\d)(\d)" $1 $2 fen

"(([A-Z]{3}) [-−]?\d+)[.,](01)" $1 $(\2:ss, 1)
"(([A-Z]{3}) [-−]?\d+)[.,](\d)" $1 $(\2:sp, \30)
"(([A-Z]{3}) [-−]?\d+)[.,](\d\d)" $1 $(\2:sp, \3)

# cardinals (cardf, cardm, cardn, cardr)

"cardn 1" ett
"card[fmnr] (.*)" $(card:|$1)
"card:(.*[^ ]e)t(tusen.*)" $(card:\1n\2) 	# 21000, 31000 .. 991000
"card:(.*e)tt([ ].*|$)" $(card:\1n\2)		# !etthundra, !ettusen
card:(.*) \1

#  ordinals (ordf, ordn, ordm)

"ordm? ([-−]?\d+)" $(ord:|$1)
ord:(.*)ett	\1förste	# 1
ord:(.*)två	\1andre		# 2
ord:(.*)tre	\1tredje	# 3
ord:(.*)fyra	\1fjärde	# 4
ord:(.*)sex	\1sjätte	# 6
ord:(.*(sju|io)) \1nde		# 7, 9, 10, 20..90
ord:(.*)åtta	\1åttonde	# 8
ord:(.*)elva	\1elfte		# 11
ord:(.*)tolv	\1tolfte	# 12
"ord:(.*(ton|hundra|tusen)) *"	\1de	# 13, 14..19, 100, 1000
"ord:(.*)er *"	\1te		# milljoner...
"ord:(.*[^ ]) *"	\1te	# 0, 5, milljon...

"ord[fn] ([-−]?\d+)" $(ordf:$(ord:|$1))
ordf:(.*(först|andr))e \1a	# 1, 2
ordf:(.*)	\1

# ordinal abbreviation

"orda[fn] (.*[02-9][12]|[12])"	\1:a
"orda[fnm]? (.*)"	\1:e

# year

"year ([-−]?(1[1-9]|[2-9]\d))(\d\d)" $1hundra$3
"year (.*)" $1

help Functions\ncardf, cardm, cardn, cardr: cardinal numbers\norda, ordaf, ordam, ordan: ordinal abbreviation\nord, ordf, ordm, ordn: ordinal numbers\nyear: spell out of years
"""
from __future__ import unicode_literals
